﻿uses GraphABC;

procedure DrawDemocharesGraph();
var
  x0, y0, scale: integer;
  
  // Функция: f(x) = x/4 + x/5 + x/3 + 13 - x
  function f(x: real): real;
  begin
    Result := x/4 + x/5 + x/3 + 13 - x;
  end;
  
  // Альтернативная форма: f(x) = -13x/60 + 13
  function f_simplified(x: real): real;
  begin
    Result := 13 - (13*x)/60;
  end;
  
begin
  // Настройки окна
  Window.Title := 'Жизнь Демохара граф';
  Window.SetSize(800, 500);
  Window.CenterOnScreen;
  
  // Фон
  Brush.Color := Color.White;
  FillRectangle(0, 0, Window.Width, Window.Height);
  
  // Начало координат и масштаб
  x0 := 100;    // Отступ слева
  y0 := 400;    // Нулевая линия по Y (f(x) = 0)
  scale := 6;   // Пикселей на единицу (для возрастов 0-100)
  
  // Рисуем ось X (возраст)
  Pen.Color := Color.Black;
  Pen.Width := 2;
  Line(50, y0, Window.Width - 50, y0);
  
  // Подписи на оси X (возраст в годах)
  for var i := 0 to 100 do
    if i mod 10 = 0 then
    begin
      var xpos := x0 + i * scale;
      // Отметки
      Line(xpos, y0 - 5, xpos, y0 + 5);
      // Числа
      if i = 60 then
      begin
        Font.Color := Color.Red;
        Font.Style := fsBold;
      end
      else
      begin
        Font.Color := Color.Black;
        Font.Style := fsNormal;
      end;
      TextOut(xpos - 8, y0 + 10, i.ToString);
    end;
  
  Font.Color := Color.Black;
  TextOut(Window.Width - 40, y0 + 10, 'x');
  TextOut(x0 + 350, y0 + 30, 'Возраст Демохара (лет)');
  
  // Рисуем ось Y (разность f(x))
  Line(x0, 50, x0, Window.Height - 50);
  
  // Подписи на оси Y (значения функции)
  for var i := -15 to 15 do
    if i mod 5 = 0 then
    begin
      var ypos := y0 - i * scale * 3; // Увеличим масштаб по Y
      // Отметки
      Line(x0 - 5, ypos, x0 + 5, ypos);
      // Числа
      TextOut(x0 - 25, ypos - 8, i.ToString);
    end;
  TextOut(x0 - 20, 40, 'f(x)');
  
  // Рисуем прямую f(x) = 13 - (13/60)x
  Pen.Color := Color.Blue;
  Pen.Width := 3;
  
  var first := true;
  for var i := 0 to 100 do
  begin
    var x := i;
    var y := f_simplified(x); // или f(x) - они эквивалентны
    var xpos := x0 + x * scale;
    var ypos := y0 - Round(y * scale * 3); // Усиливаем масштаб по Y
    
    if first then
    begin
      MoveTo(xpos, ypos);
      first := false;
    end
    else
      LineTo(xpos, ypos);
  end;
  
  // Отмечаем корень уравнения f(x) = 0
  var root := 60;
  var y_root := f_simplified(root); // = 0
  var xpos_root := x0 + root * scale;
  var ypos_root := y0 - Round(y_root * scale * 3);
  
  // Красная точка - решение
  Pen.Color := Color.Red;
  Pen.Width := 6;
  Circle(xpos_root, ypos_root, 8);
  
  // Вертикальная пунктирная линия к оси X
  Pen.Color := Color.Gray;
  Pen.Width := 1;
  Pen.Style := psDash;
  Line(xpos_root, ypos_root, xpos_root, y0);
  Pen.Style := psSolid;
  
  // Подпись корня
  Brush.Color := Color.White;
  Pen.Color := Color.Red;
  Font.Size := 12;
  Font.Style := fsBold;
  Font.Color := Color.Red;
  TextOut(xpos_root - 15, ypos_root - 30, 'x = 60');
  
  // Уравнение в углу
  Brush.Color := Color.LightYellow;
  FillRectangle(10, 10, 400, 100);
  Pen.Color := Color.Black;
  Rectangle(10, 10, 400, 100);
  
  Font.Size := 12;
  Font.Color := Color.Black;
  Font.Style := fsBold;
  TextOut(20, 15, 'Уравнение Демохара:');
  Font.Style := fsNormal;
  TextOut(20, 35, 'x/4 + x/5 + x/3 + 13 = x');
  TextOut(20, 55, 'или: f(x) = 13 - (13/60)x = 0');
  Font.Size := 10;
  TextOut(20, 75, 'Решение: x = 60 лет');
  
  // Пояснение периодов жизни
  Brush.Color := Color.LightCyan;
  FillRectangle(Window.Width - 350, 10, Window.Width - 10, 130);
  Pen.Color := Color.Black;
  Rectangle(Window.Width - 350, 10, Window.Width - 10, 130);
  
  Font.Size := 10;
  Font.Color := Color.Black;
  TextOut(Window.Width - 340, 15, 'Периоды жизни (60 лет):');
  TextOut(Window.Width - 340, 30, '• Детство (1/4):  60/4 = 15 лет');
  TextOut(Window.Width - 340, 45, '• Юность (1/5):   60/5 = 12 лет');
  TextOut(Window.Width - 340, 60, '• Зрелость (1/3): 60/3 = 20 лет');
  TextOut(Window.Width - 340, 75, '• Пожилой возраст: 13 лет');
  TextOut(Window.Width - 340, 90, '• Проверка: 15+12+20+13 = 60 лет');
  
  // Легенда графика
  Brush.Color := Color.White;
  FillRectangle(Window.Width - 350, 150, Window.Width - 10, 200);
  Pen.Color := Color.Black;
  Rectangle(Window.Width - 350, 150, Window.Width - 10, 220);
  
  TextOut(Window.Width - 340, 155, 'Легенда:');
  Pen.Color := Color.Blue;
  Line(Window.Width - 340, 175, Window.Width - 300, 175);
  TextOut(Window.Width - 295, 170, 'f(x) = 13 - (13/60)x');
  
  Pen.Color := Color.Red;
  Circle(Window.Width - 320, 195, 4);
  TextOut(Window.Width - 295, 190, 'Решение: f(60) = 0');
  
  // Горизонтальная линия y=0
  Pen.Color := Color.Black;
  Pen.Style := psSolid;
  Pen.Width := 1;
end;

begin
  DrawDemocharesGraph();
end.